% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.IC2.R
\name{plot.IC2}
\alias{plot.IC2}
\title{Plot the IC2 object}
\usage{
\method{plot}{IC2}(
  x,
  xlab = "Time",
  ylab = "Survival",
  legend = NULL,
  main = "Survival Function",
  lty = 1:9,
  lwd = 1,
  xleg = 0,
  yleg = 0.15,
  col = gray(0),
  ...
)
}
\arguments{
\item{x}{The IC2 object, see \code{\link{IC2MM}}.}

\item{xlab}{x label, default is 'Time'.}

\item{ylab}{y label, default is 'Survival'.}

\item{legend}{legend, default=NULL.}

\item{main}{figure title, default is 'Survival Function'}

\item{lty}{lty value for line, default is 1:9.}

\item{lwd}{line width, default is 1.}

\item{xleg}{positional parameters of the legend, default=0.}

\item{yleg}{positional parameters of the legend, default=0.15 .}

\item{col}{the color of the drawing, default=gray(0)}

\item{...}{Additional arguments}
}
\value{
A list of arguments for the legend. Values are x, y, legend, fill, lty, bty, col.
}
\description{
Plot the IC2 object
}
\examples{

library(survival)
result = IC2MM(Surv(left, right, type = 'interval2') ~ treatment, bcos)

plot(result, col=c('red', 'blue'))


}
