% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/most_typical.R
\name{most_typical}
\alias{most_typical}
\title{Identification of the most typical case}
\usage{
most_typical(lmobject)
}
\arguments{
\item{lmobject}{Object generated with \code{\link[stats]{lm}}}
}
\value{
The most typical case having the smallest absolute
residual of all cases.
}
\description{
The most typical case (= best predicted case) based on regression estimates.
}
\details{
Proposed by Seawright, Jason and John Gerring (2008):
Case Selection Techniques in Case Study Research: A Menu of
Qualitative and Quantitative Options. \emph{Political Research Quarterly}
61 (2): 294-308.
(\url{https://journals.sagepub.com/doi/pdf/10.1177/1065912907313077})
}
\examples{
df <- lm(mpg ~ disp + wt, data = mtcars)
most_typical(df)

}
