% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProduct.R
\name{addProduct}
\alias{addProduct}
\title{Add New Product to MODIS Inventory}
\usage{
addProduct(product, sensor = "MODIS", platform = c("Terra", "Aqua"), pf1,
  pf2, topic, type = c("Tile", "Swath", "CMG"), res, temp_res,
  internalseparator = "\\\\.", server = c("LPDAAC", "LAADS"),
  path_ext = "inst/external", overwrite = FALSE, ...)
}
\arguments{
\item{product}{Character. Name of the product that should be added to the 
inventory, see \code{\link{getProduct}}.}

\item{sensor}{Character. Sensor type, defaults to 'MODIS'.}

\item{platform}{Character. Satellite platform on which the specified 'sensor' 
is mounted, defaults to "Terra".}

\item{pf1, pf2}{Character. Online server paths.}

\item{topic}{Character. The official name of 'product'.}

\item{type}{Character. Product type, defaults to 'Tile'.}

\item{res}{Character. Spatial resolution of 'product', e.g. "1000m".}

\item{temp_res}{Character. Temporal resolution of 'product', e.g. "8 Day".}

\item{internalseparator}{Character. Separator string matching the product's 
naming convention, defaults to '\\.' for MODIS products.}

\item{server}{Character. Server to download the data from (more than one 
entry is possible).}

\item{path_ext}{Character. Path to folder containing file 
'MODIS_Products.RData'. When working with RStudio projects (.Rproj), this 
usually defaults to 'inst/external'.}

\item{overwrite}{Logical. If \code{TRUE}, the initial '.RData' file located 
in 'path_ext' will be overwritten.}

\item{...}{Currently not used.}
}
\value{
A 'list' holding the updated contents of file 'MODIS_Products.RData'.
}
\description{
\code{addProduct} is a non-exported helper function to add a new entry to the 
list of satellite products featured by \strong{MODIS} (see 
\code{MODIS:::MODIS_Products}).
}
\examples{
\dontrun{
## E.g., add MODIS evapotranspiration product
MODIS:::addProduct(product = "MOD16A2", sensor = "MODIS", platform = "Combined", 
                   pf1 = "MOLT", pf2 = "MOD", res = "1000m", temp_res = "8 Day", 
                   topic = "Global Terrestrial Evapotranspiration", server = "NTSG")
}
     
}
\seealso{
\code{MODIS:::MODIS_Products}, \code{\link{getProduct}}.
}
\author{
Florian Detsch
}
