% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_resetindexes.R
\name{MODIStsp_resetindexes}
\alias{MODIStsp_resetindexes}
\title{Remove custom spectral indexes}
\usage{
MODIStsp_resetindexes()
}
\value{
The function is called for its side effects. On success, the
MODIStsp_indexes.json file is modified so to
remove all previously custom-specified Spectral Indexes.
}
\description{
Function used to remove all user-defined Spectral Indexes from
MODIStsp, thus resetting the list of available indexes
to the default ones.
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
# Remove all custom-defined spectral indexes from an options file

# Add a custom index for testing purposes
library(jsonlite)
opts_jsfile = system.file("testdata/test_addindex.json",
                             package = "MODIStsp")
 MODIStsp_addindex(
   opts_jsfile = opts_jsfile,
   gui = FALSE,
   new_indexbandname = paste0("Index_", as.character(sample(10000, 1))),
   new_indexformula = "b1_Red - b2_NIR",
   new_indexfullname = paste0("Index_", as.character(sample(10000, 1)))
   )

 opts <- jsonlite::fromJSON(indexes_file)
 opts$custom_indexes[1]

 # Now remove all custom indexes
 MODIStsp_resetindexes()
 opts <- jsonlite::fromJSON(opts_jsfile)
 opts$custom_indexes[1]
 }

}
\seealso{
\link{MODIStsp_addindex}
}
\author{
Lorenzo Busetto, phD (2014-2017) \email{busetto.l@irea.cnr.it}
}
