% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moss_signatures.R
\name{moss_signatures}
\alias{moss_signatures}
\title{Returns signatures of features by groups of subjects}
\usage{
moss_signatures(
  data.blocks,
  moss_select.out,
  clus_lab = NULL,
  plot = FALSE,
  feature.labels = NULL,
  th = 1,
  only.candidates = FALSE
)
}
\arguments{
\item{data.blocks}{A list of omic blocks as provided to moss.}

\item{moss_select.out}{The output of moss_select.}

\item{clus_lab}{A vector of same length than number of subjects 
with labels used to visualize clusters. Defaults to NULL.}

\item{plot}{Should the results be plotted? Logical. 
Defaults to FALSE}

\item{feature.labels}{List with with features names for each omic.
Defaults to NULL.}

\item{th}{Show the th% features of largest loadings (in absolute value). 
Default to th=1 (all the features). Numeric.}

\item{only.candidates}{Should we plot only candidate features? Logical.}
}
\value{
Returns a list with 'signatures', and if plot=TRUE,
a ggplot object named 'sig_plot'. The element 'signatures'
is a data frame with columns corresponding to 'Cluster' (groups
of subjects), 'Omic', 'Dim' (PC index or latent dimension),
'Feature_name', 'Feature_pos' (column index of the selected
feature within the corresponding omic), 'Loadings' (non-zero 
loadings from moss), 'Means', 'L1' and 'L2' (mean +/- standard
error of the selected feature values within an omic).
}
\description{
This function is meant to used after moss_select.
Its main purpose is to visualize how each selected feature (
non-zero loading feature) contributes to each group of subjects by 
latent dimension.
}
\examples{
\donttest{
library("MOSS")
# Extracting simulated omic blocks.
sim_data <- simulate_data()
sim_blocks <- sim_data$sim_blocks

# Extracting subjects and features labels.
lab.sub <- sim_data$labels$lab.sub

out <- moss(sim_blocks[-4],
  method = "pca",
  nu.v = 10,
  exact.dg = TRUE,
  plot = TRUE,
  alpha.v = 0.5
)
out2 <- moss_select(data.blocks = sim_blocks[-4],
                    SVD = out$sparse,
                    plot = TRUE)

# Display signature plots.
out3 <- moss_signatures(data.blocks = sim_blocks[-4],
                        clus_lab=lab.sub,
                        moss_select.out = out2,
                        plot = TRUE)
out3$sig_plot 
}                               
}
