% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RelativeCosts1.R
\name{RelativeCosts1}
\alias{RelativeCosts1}
\title{The relative cost of reduced factorial designs}
\usage{
RelativeCosts1(number_of_factors, desired_fract_resolution = 4,
  min_target_d_per_factor = 0.2, condition_costlier_than_subject = 1,
  max_graph_ratio = 5)
}
\arguments{
\item{number_of_factors}{The number of factors to be tested.}

\item{desired_fract_resolution}{The desired resolution of the fractional factorial experiment to be compared.
The default value is set to be 4.}

\item{min_target_d_per_factor}{The minimum Cohen's d (standardized difference, i.e., response difference
between levels on a given factor, divided by response standard deviation)
that is desired to be detected with 80% probability for any given factor.
The default value is set to be 0.2.}

\item{condition_costlier_than_subject}{The default value is set to be 1.}

\item{max_graph_ratio}{The default value is set to be 5.}
}
\description{
Draw a graph of the relative cost of complete factorial,
             fractional factorial, and unbalanced reduced factorial designs,
             as presented by Collins, Dziak and Li
             (2009; https://www.ncbi.nlm.nih.gov/pubmed/19719358).  For
             purposes of illustration, a normally distributed response variable,
             dichotomous factors, and negligible interactions are assumed in this function.
}
\examples{
RelativeCosts1(number_of_factors = 9,
              desired_fract_resolution = 4,
              min_target_d_per_factor = .2,
              condition_costlier_than_subject=1,
              max_graph_ratio = 4)
}

