% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_results.R
\name{check_results}
\alias{check_results}
\alias{write_check_results}
\alias{check_set}
\title{Check results from MPTmultiverse}
\usage{
check_results(results)

write_check_results(DATA_FILE, results, append = FALSE)

check_set(results)
}
\arguments{
\item{results}{An object of class multiverseMPT.}

\item{DATA_FILE}{character string. File name to use.}

\item{append}{logical. If \code{TRUE}, output will be appended to
\code{DATA_FILE}; otherwise, it will overwrite the contents of
\code{DATA_FILE}.}
}
\description{
Set of helper functions that allow checking if model estimation
  worked as intended. Depending on the method and function, these functions
  return slightly different information.
}
\details{
\code{check_results} prints relatively verbose output detailing
  diagnostic information for each method to the console. For the frequentist
  methods, this is based on either the rank of the observed Fischer (or
  Hessian) matrix of the MLE estimate or based on empirical identifiability
  (based either on repeated re-runs or the width of the bootstrapped
  parameter distribution). For the Bayesian methods, this is convergence
  statistics R-hat and number of effective samples.
  \code{write_check_results} writes the results of \code{check_results} to a
  specififed file (instead of printing it to the console).

  \code{check_set} returns a \code{tibble} with one row, where each expected
  method corresponds to a column with a boolean (\code{TRUE}/\code{FALSE})
  value. Entries \code{TRUE} correspond to no problem and \code{FALSE}
  correspond to problems. \code{FALSE} means the method is either missing
  from the results file or (for the Bayesian methods) there are core
  parameters for which the convergence criteria defined in
  \code{getOption("MPTmultiverse")} are not met.
}
\examples{
load(file = system.file("extdata", "results_bayen_kuhlmann.RData",
                        package = "MPTmultiverse"))
## prints checks to console
check_results(results)

## returns tibble with single row
check_set(results)
}
