% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.MRFA.R
\name{cv.MRFA}
\alias{cv.MRFA}
\title{Compute K-fold cross-validated error for Multi-Resolution Functional ANOVA (MRFA) Model}
\usage{
cv.MRFA(X, Y, order = 10, level = 10, lambda = exp(seq(log(500),
  log(0.001), by = -0.01)), K = 10, plot.it = TRUE, parallel = FALSE,
  verbose = FALSE, ...)
}
\arguments{
\item{X}{input for \code{MRFA_fit}.}

\item{Y}{input for \code{MRFA_fit}.}

\item{order}{input for \code{MRFA_fit}.}

\item{level}{input for \code{MRFA_fit}.}

\item{lambda}{lambda values at which CV curve should be computed.}

\item{K}{a positive integer specifying the number of folds.}

\item{plot.it}{logical. If \code{TRUE}, a CV curve will be shown. The default is \code{TRUE}.}

\item{parallel}{logical. If \code{TRUE}, apply cross-validation function in parallel using parallel backend provided by foreach. The default is \code{FALSE}.}

\item{verbose}{logical. If \code{TRUE}, additional diagnostics are printed. The default is \code{FALSE}.}

\item{...}{additional arguments to \code{MRFA_fit}.}
}
\value{
\item{lambda}{lambda values at which CV curve is computed.}
\item{cv}{the CV curve at each value of lambda.}
\item{cv.error}{the standard error of the CV curve}
}
\description{
Computes the K-fold cross validated mean squared prediction error for multiresolution functional ANOVA model.
}
\examples{
\dontrun{

#####             Testing function: GRAMACY & LEE (2009) function             #####
#####   Thanks to Sonja Surjanovic and Derek Bingham, Simon Fraser University #####
grlee09 <- function(xx)
{
  x1 <- xx[1]
  x2 <- xx[2]
  x3 <- xx[3]
  x4 <- xx[4]
  x5 <- xx[5]
  x6 <- xx[6]

  term1 <- exp(sin((0.9*(x1+0.48))^10))
  term2 <- x2 * x3
  term3 <- x4

  y <- term1 + term2 + term3
  return(y)
}

library(MRFA)
#####   Training data and testing data   #####
set.seed(2)
n <- 100; n_rep <- 3; n_new <- 50; d <- 6
X.train <- matrix(runif(d*n), ncol = d)
X.train <- matrix(rep(X.train, each = n_rep), ncol = d)
Y.train <- apply(X.train, 1, grlee09)
Y.train <- Y.train + rnorm(n*n_rep, 0, 0.05)
X.test <- matrix(runif(d*n_new), ncol = d)
Y.test <- apply(X.test, 1, grlee09)

#####   Computes the K-fold cross validated   #####
cv.out <- cv.MRFA(X.train, Y.train, K = 5, lambda = seq(0.01,3,0.1))

#####   Prediction : CV  ######
lambda_cv <- cv.out$lambda[which.min(cv.out$cv)]
Y.pred <- predict(MRFA_model, X.test, lambda = lambda_cv)$y_hat
print(sqrt(mean((Y.test - Y.pred)^2)))
}
}
\author{
Chih-Li Sung <iamdfchile@gmail.com>
}
\seealso{
\code{\link{MRFA_fit}} for fitting a multiresolution functional ANOVA model.
}

