% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRGpostProcess.R
\name{MRGpostProcess}
\alias{MRGpostProcess}
\title{Make some final adjustments to the multiresolution grids}
\usage{
MRGpostProcess(himg, vars, remCols = TRUE, rounding = "varying")
}
\arguments{
\item{himg}{The grid resulting from a call to multiResGrid}

\item{vars}{Variable(s) of interest that should be aggregated (necessary when ifg is
used for individual farm specific anonymization rules)}

\item{remCols}{Logical; Should intermediate columns be removed? Can be set
to FALSE for further analyses. Temporary columns will not be removed if their names 
partly match the variable names of \code{vars}}

\item{rounding}{either logical (FALSE) or an integer indicating the number 
of decimal places 
 to be used. Negative values are allowed (such as the default
 value rounding to the closest 10). See also the details
 for \code{digits} in \code{\link{round}}.}
}
\value{
The function will return a post-processed multi-resolution grid
with non-confidential gridded data. See \code{\link{multiResGrid}} for more 
information.
}
\description{
Make some final adjustments to the multiresolution grids
}
\details{
The postprocessing function is normally called directly from \code{\link{multiResGrid}}. 
However, it might be useful to check the values of the grid cells that
will be suppressed, and the values before rounding. In that case 
\code{\link{multiResGrid}} can be called with the argument \code{postProcess = FALSE}, 
and the post processing be done separately.
}
\examples{
\donttest{
library(sf)

# These are SYNTHETIC agricultural FSS data 
data(ifs_dk) # Census data
# Create spatial data
ifg = fssgeo(ifs_dk, locAdj = "LL")

# Set the base resolutions, and create a hierarchical list with gridded data
ress = 1000*2^(1:7)
ifl = gridData(ifg, "UAA", res = ress)
himg = multiResGrid(ifl, ifg = ifg, var = "UAA", weight = "EXT_CORE", postProcess = FALSE)
himgp = MRGpostProcess(himg, var = "UAA")

# Confidential grid cells, being suppressed in postProcessing
himg[himg$confidential,]
 }
}
