% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/print.summary.mrs.R
\name{print.summary.mrs}
\alias{print.summary.mrs}
\title{Print summary of a mrs object}
\usage{
\method{print}{summary.mrs}(x, ...)
}
\arguments{
\item{x}{A \code{summary.mrs} object}

\item{...}{Additional print parameters.}
}
\description{
This function print the summary the output of the \code{\link{mrs}} function.
It provides the marginal prior and posterior of the null and the top regions of the representative tree.
}
\examples{
set.seed(1)
n = 100
p = 2
X = matrix(c(runif(p*n/2),rbeta(p*n/2, 1, 4)), nrow=n, byrow=TRUE)
G = c(rep(1,n/2), rep(2,n/2))
x = mrs(X=X, G=G)
fit = summary(x, rho = 0.95, abs_eff = 1)
print(fit)
}
\references{
Soriano J. and Ma L. (2017).
Probabilistic multi-resolution scanning for two-sample differences.
 \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}.
  \doi{10.1111/rssb.12180}

Ma L. and Soriano J. (2018).
Analysis of distributional variation through multi-scale Beta-Binomial modeling.
 \emph{Journal of Computational and Graphical Statistics. Vol. 27, No. 3, 529-541.}.
 \doi{10.1080/10618600.2017.1402774}
}

