% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotProximalEffect.R
\name{plotProximalEffect}
\alias{plotProximalEffect}
\title{plot the graph for the proximal treatment effect}
\usage{
plotProximalEffect(
  days,
  occ_per_day,
  beta_shape,
  beta_mean,
  beta_initial,
  beta_quadratic_max
)
}
\arguments{
\item{days}{Duration of the study.}

\item{occ_per_day}{Number of decision time points per day.}

\item{beta_shape}{The trend for the proximal treatment effect, choices are constant, linear or quadratic.
Note:
\enumerate{
            \item{Constant} The proximal treatment effect stays constant over the study.
            \item{Linear} The linearly increasing form of a proximal treatment effect might be
            used if participants will get more enthusiastically engage in the apps and thus
            the proximal effect will increase as the study goes. The linearly decreasing form
            of a proximal treatment effect might be used if participants are likely to disengage
            the activity suggestionss and thus the proximal effect will decrease as the study goes.
            \item{Quadratic}  The quadratic form of a proximal treatment effect might be used if
            you expect that initially participants will enthusiastically engage in the apps and
            thus the proximal effect will get higher. Then, as the study goes on, some participants
            are likely to disengage or begin to ignore the activity suggestions and hence a downward
            trend.
}}

\item{beta_mean}{Average of proximal treatment effect.}

\item{beta_initial}{Initial value of proximal treatment effect when beta_shape is linear or quadratic.}

\item{beta_quadratic_max}{Day of maximal proximal treatment effect when beta_shape is quadratic.}
}
\value{
A graph for the proximal treatment effect.
}
\description{
plot of the graphs for the proximal treatment effect when the trend for
the proximal treatment effect is constant, linear or quadractic.
}
\examples{
plotProximalEffect(days=42,
                   occ_per_day=5,
                   beta_shape="quadratic",
                   beta_mean=0.1,
                   beta_initial=0,
                   beta_quadratic_max=28)


}
