% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_state_matrices.R
\name{make_state_matrices}
\alias{make_state_matrices}
\title{Construct state matrices from longitudinal EHR Data}
\usage{
make_state_matrices(
  data,
  id = "link_id",
  ltc = "reg",
  aos = "aos",
  l = 111,
  fail_code = "death",
  cens_code = "cens"
)
}
\arguments{
\item{data}{A data frame containing one row per condition occurrence.}

\item{id}{Name of the column identifying individuals.}

\item{ltc}{Name of the column containing LTC labels.}

\item{aos}{Name of the column giving age of onset (or time of onset) for each LTC.}

\item{l}{The maximum time index (inclusive); matrix has \code{l + 1} time rows per LTC.}

\item{fail_code}{Label in \code{ltc} indicating a failure event (e.g., death).}

\item{cens_code}{Label in \code{ltc} indicating censoring.}
}
\value{
A matrix with \verb{(l + 1) * number of LTCs} rows and
one column per unique individual. Values are 1 after onset, 0 before, and NA after censor/fail.
Rows are named \verb{<ltc>_<time>}, and columns are individual IDs.
}
\description{
Builds a binary matrix (0/1/NA) encoding whether each individual had each long-term
condition (LTC) at each time point from 0 to \code{l}, based on their age of onset. The matrix
includes all LTCs, including those used to determine censoring and failure. However, the
presence of \code{fail_code} or \code{cens_code} still triggers NA values after their onset.
}
\note{
For large datasets, computations may be split into multiple jobs to manage memory and performance. Consider reducing the time granularity and/or the number of long-term condition (event of interest) to improve efficiency and stability.
}
\references{
Delord M, Douiri A (2025) \url{doi:10.1186/s12874-025-02476-7}
}
\author{
@author Marc Delord
}
\concept{Censored state matrix}
\keyword{Censored}
\keyword{matrix}
\keyword{state}
