% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StarQuartetHypTest.R
\name{quartetStarTestInd}
\alias{quartetStarTestInd}
\title{Multiple independent hypothesis tests for gene quartet counts fitting 
a species quartet star tree under the MSC}
\usage{
quartetStarTestInd(rqt)
}
\arguments{
\item{rqt}{Table of resolved quartet counts, as produced by \code{quartetTableResolved}, or \code{quartetTreeTestInd}}
}
\value{
the same table as the input \code{rqt} with column \code{"p_star"} appended, containing p-values for 
judging fit to MSC on a star tree
}
\description{
Perform hypothesis tests for a species quartet star tree vs. any alternative for all quartet counts in an input table, 
as if the quartets are independent.
}
\details{
This function assumes all quartets are resolved. 
The test performed is described in \code{quartetStarTest}.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
pTable=quartetStarTestInd(RQT)
quartetTablePrint(pTable[1:6,])

}
\seealso{
\code{\link{quartetStarTest}}, \code{\link{quartetTreeTest}}, \code{\link{quartetTreeTestInd}},
\code{\link{quartetTableResolved}}, \code{\link{quartetTestPlot}}
}
