% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToBtoLevel1.R
\name{combineCycleResolutions}
\alias{combineCycleResolutions}
\title{Combine several cycle resolutions on a tree of blobs to create a network}
\usage{
combineCycleResolutions(ToB, resolutions, plot = 1, titletext = NULL)
}
\arguments{
\item{ToB}{an unrooted tree of blobs for the network, with multifurcating nodes
labelled by \code{\link{labelIntNodes}}}

\item{resolutions}{a list of resolutions (each of which may be a list)
for different nodes with elements in format described in output of \code{\link{resolveCycle}}}

\item{plot}{if FALSE (0), no plots; if TRUE (>0) plot networks}

\item{titletext}{a string of text for plot}
}
\value{
a list of Newick strings for the networks, with all edge lengths 1
}
\description{
Given a list of resolutions of different multifurcations on a tree of blobs
(each as produced by \code{\link{resolveCycle}}), combine these with the tree
of blobs to form a network.
}
\details{
This function is useful for forming near-optimal networks when there are
several resolutions that have similar fit for some of the multifurcations.
}
\examples{
data(pTableYeastRokas)
out=TINNIK(pTableYeastRokas, alpha=.01, beta=.05)
ToB=labelIntNodes(out$ToB)
R9=resolveCycle(ToB, node=9, pTable=out$pTable, alpha=.01, beta=.05, distance="NANUQ")
R10=resolveCycle(ToB, node=10, pTable=out$pTable, alpha=.01, beta=.05, distance="NANUQ")
combineCycleResolutions(ToB, resolutions=list(R9,R10),plot=TRUE)

}
\seealso{
\code{\link{TINNIK}}, \code{\link{labelIntNodes}}, \code{\link{resolveCycle}},
 \code{\link{resolveLevel1}}
}
