% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToBtoLevel1.R
\name{resolveCycle}
\alias{resolveCycle}
\title{Resolve a node on a tree of blobs as a cycle}
\usage{
resolveCycle(
  ToB,
  node,
  pTable,
  test = "T3",
  alpha,
  beta,
  distance = "NANUQ",
  hdegree = 10,
  plot = TRUE,
  delta = 10^-6
)
}
\arguments{
\item{ToB}{an unrooted tree of blobs (phylo object), as determined by TINNIK
or another method, with multifurcations labelled by \code{labelIntNodes}}

\item{node}{number of an internal node to be resolved}

\item{pTable}{a table of qcCFs, with columns p_star and p_test}

\item{test}{either "T3" or "cut", indicating the test to use for determining what
qcCFs indicate hybridization}

\item{alpha}{test level for p_test}

\item{beta}{test level for p_star}

\item{distance}{cycle resolution distance to be used; one of "NANUQ" or "modNANUQ"}

\item{hdegree}{resolve a multifurcation of this degree or larger by a heuristic
method; must be at least 5}

\item{plot}{if FALSE (0), no plots; if TRUE (>0), make plots of resolved cycle(s) considered
best and histogram of measure of fit for all hybrid/orders considered}

\item{delta}{cutoff for relative difference in squared residuals and smallest,
(RSS-minRSS)/minRSS, for determining near ties as "best" fit resolutions}
}
\value{
a list of resolution information, given as a list of:
\itemize{
\item \code{$node} node number,
\item \code{$cycleRes} list [[1]]-[[k]] of  best resolutions,
\item \code{$RSSs} RSSs from all cycle resolutions considered in choosing best.
}
Each resolution is itself a 5-element list with entries:
\itemize{
\item \code{$cycleNet} Newick network with 1 cycle (with all edge lengths 1)
\item \code{$cycleRSS} RSS for cycle,
\item \code{$taxonGroups} taxon groups for cycle,
\item \code{$order} order of groups around cycle,
\item \code{$nonRootEdges} logical vector indicating edges of \code{ToB}
where root cannot be.
}
(Items \code{$taxonGroups,$order,$nonRootEdges} are
needed to combine resolutions to form networks with multiple cycles using
\code{\link{combineCycleResolutions}}, and otherwise may not be of interest to users).
}
\description{
Given a Tree of Blobs and quartet Concordance Factor data, resolve a specific
polytomy to a cycle. Resolution is performed by finding a least-squares
best-fit of an empirical distance to an expected distance related to the cycle,
as described in \insertCite{ABRW24;textual}{MSCquartets}.
}
\details{
Possible distances to use are the NANUQ distance and a modified NANUQ distance
that weights quartet trees differently, but from which the cycle structure is
still identifiable.

For multifucations of degree less than a designated cutoff, all possible
circular orders and choices of hybrid nodes are considered in choosing the
best. Above that cutoff, a heuristic method built on the modified NANUQ
distance is used to obtain a small number of orders likely to be good fits,
with the least-squares fitting applied only to those.
}
\examples{
data(pTableYeastRokas)
out=TINNIK(pTableYeastRokas, alpha=.01, beta=.05)
ToB=labelIntNodes(out$ToB)
resolveCycle(ToB, node=9, pTable=out$pTable, alpha=.01, beta=.05, distance="NANUQ")

}
\references{
\insertRef{ABRW24}{MSCquartets}
}
\seealso{
\code{\link{TINNIK}}, \code{\link{labelIntNodes}}, \code{\link{combineCycleResolutions}},
\code{\link{resolveLevel1}}
}
