% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_cDD.R
\name{cDD}
\alias{cDD}
\alias{cDD_SS}
\title{Continuous Delay-differential assessment model}
\usage{
cDD(x = 1, Data, SR = c("BH", "Ricker"), rescale = "mean1",
  start = NULL, fix_h = TRUE, fix_F_equilibrium = TRUE, n_itF = 5L,
  silent = TRUE, opt_hess = FALSE, n_restart = ifelse(opt_hess, 0,
  1), control = list(iter.max = 5000, eval.max = 10000), ...)

cDD_SS(x = 1, Data, SR = c("BH", "Ricker"), rescale = "mean1",
  start = NULL, fix_h = TRUE, fix_F_equilibrium = TRUE,
  fix_sigma = FALSE, fix_tau = TRUE, n_itF = 5L, integrate = FALSE,
  silent = TRUE, opt_hess = FALSE, n_restart = ifelse(opt_hess, 0,
  1), control = list(iter.max = 5000, eval.max = 10000),
  inner.control = list(), ...)
}
\arguments{
\item{x}{An index for the objects in \code{Data} when running in closed loop simulation.
Otherwise, equals to 1 when running an assessment.}

\item{Data}{An object of class \linkS4class{Data}.}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt or \code{"Ricker"}).}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{start}{Optional list of starting values. Entries can be expressions that are evaluated in the function. See details.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep} in the assessment model.}

\item{fix_F_equilibrium}{Logical, whether the equilibrium F prior to the first year of the model is
estimated. If TRUE, F_equilibruim is fixed to value provided in start (if provided), otherwise, equal to zero
(assumes unfished conditions).}

\item{n_itF}{Integer, the number of iterations to solve F conditional on the observed catch.}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for dignostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of parameters regarding optimization to be passed to
\code{\link[stats]{nlminb}}.}

\item{...}{Additional arguments (not currently used).}

\item{fix_sigma}{Logical, whether the standard deviation of the index is fixed. If \code{TRUE},
sigma is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@CV_Ind}.}

\item{fix_tau}{Logical, the standard deviation of the recruitment deviations is fixed. If \code{TRUE},
tau is fixed to value provided in \code{start} (if provided), otherwise, equal to 1.}

\item{integrate}{Logical, whether the likelihood of the model integrates over the likelihood
of the recruitment deviations (thus, treating it as a state-space variable). Otherwise, recruitment deviations are penalized parameters.}

\item{inner.control}{A named list of arguments for optimization of the random effects, which
is passed on to \code{\link[TMB]{newton}} via \code{\link[TMB]{MakeADFun}}.}
}
\value{
An object of \code{\linkS4class{Assessment}} containing objects and output
from TMB.
}
\description{
A catch and index-based assessment model. Compared to the discrete delay-difference (annual time-step in production and fishing), the
delay-differential model (cDD) is based on continuous recruitment and fishing mortality within a time-step. The continuous model works
much better for populations with high turnover (e.g. high F or M, continuous reproduction). This model is conditioned on catch and fits
to the observed index. In the state-space version (cDD_SS), recruitment deviations from the stock-recruit relationship are estimated.
}
\details{
To provide starting values for \code{cDD}, a named list can be provided for \code{R0} (unfished recruitment) and
and \code{h} (steepness) via the \code{start} argument (see example).

For \code{cDD_SS}, additional start values can be provided for and \code{sigma} and \code{tau}, the standard
deviation of the index and recruitment variability, respectively.
}
\section{Required Data}{

\itemize{
\item \code{cDD}: Cat, Ind, Mort, L50, vbK, vbLinf, vbt0, wla, wlb, MaxAge
\item \code{cDD_SS}: Cat, Ind, Mort, L50, vbK, vbLinf, vbt0, wla, wlb, MaxAge
}
}

\section{Optional Data}{

\itemize{
\item \code{cDD}: steep
\item \code{cDD_SS}: steep, CV_Ind, sigmaR
}
}

\examples{
#### Observation-error delay difference model
res <- cDD(Data = DLMtool::Red_snapper)

# Provide starting values
start <- list(R0 = 1, h = 0.95)
res <- cDD(Data = DLMtool::Red_snapper, start = start)

summary(res@SD) # Parameter estimates

### State-space version
### Set recruitment variability SD = 0.6 (since fix_tau = TRUE)
res <- cDD_SS(Data = Red_snapper, start = list(tau = 0.6))

}
\references{
Hilborn, R., and Walters, C., 1992. Quantitative Fisheries Stock Assessment: Choice,
Dynamics and Uncertainty. Chapman and Hall, New York.
}
\seealso{
\link{DD_TMB} \link{plot.Assessment} \link{summary.Assessment} \link{retrospective} \link{profile} \link{make_MP}
}
\author{
Q. Huynh
}
