% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_timeseries}
\alias{plot_timeseries}
\title{Plot time series of data}
\usage{
plot_timeseries(
  Year,
  obs,
  fit = NULL,
  obs_CV = NULL,
  obs_CV_CI = 0.95,
  obs_upper = NULL,
  obs_lower = NULL,
  obs_ind_blue = NULL,
  fit_linewidth = 3,
  fit_color = "red",
  label = "Observed data"
)
}
\arguments{
\item{Year}{A vector of years for the data.}

\item{obs}{A vector of observed data.}

\item{fit}{A vector of predicted data (e.g., from an assessment model).}

\item{obs_CV}{A vector of year-specific coefficient of variation in the observed data.}

\item{obs_CV_CI}{The confidence interval for the error bars based for \code{obs_CV}.}

\item{obs_upper}{A vector of year-specific upper bounds for the error bars of the observed data (in lieu of argument \code{obs_CV}).}

\item{obs_lower}{A vector of year-specific lower bounds for the error bars of the observed data (in lieu of argument \code{obs_CV}).}

\item{obs_ind_blue}{Indices of \code{obs} for which the plotted points and error bars will be blue.}

\item{fit_linewidth}{Argument \code{lwd} for fitted line.}

\item{fit_color}{Color of fitted line.}

\item{label}{Character string that describes the data to label the y-axis.}
}
\description{
Plot time series of observed (with lognormally-distributed error bars) vs.
predicted data.
}
\examples{
data(Red_snapper)
plot_timeseries(Red_snapper@Year, Red_snapper@Cat[1, ],
obs_CV = Red_snapper@CV_Cat, label = "Catch")
}
\seealso{
\code{\link{plot_residuals}}
}
\author{
Q. Huynh
}
