% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiMSE_internal.R
\name{Herm-int}
\alias{Herm-int}
\alias{expandHerm}
\alias{checkHerm}
\alias{subsetHerm}
\title{Internal Herm functions}
\usage{
expandHerm(Herm, maxage, np, nsim)

checkHerm(Herm, maxage, nsim, nyears, proyears)

subsetHerm(Herm, y)
}
\arguments{
\item{Herm}{A list of Hermaphroditic fractions at age}

\item{maxage}{The maximum age of stocks being simulated}

\item{np}{The total number of stocks being simulated}

\item{nsim}{The number of simulations}

\item{nyears}{The number of historical years}

\item{proyears}{The number of projection years}

\item{y}{The year to subset}
}
\description{
\itemize{
\item \code{expandHerm} expands the Herm list in SexPars to a matrix of fractions at age
}

\itemize{
\item \code{checkHerm} checks that each array in the list has dimension nsim x maxage+1 x nyears + proyears.
For backwards compatibility, also converts matrices to arrays by adding the year dimension.
}

\itemize{
\item \code{subsetHerm} returns year-specific Herm values.
}
}
\author{
T. Carruthers

Q. Huynh
}
