% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/State.R
\name{State}
\alias{State}
\alias{State.MSGARCH_SPEC}
\alias{State.MSGARCH_ML_FIT}
\alias{State.MSGARCH_MCMC_FIT}
\title{State probabilities.}
\usage{
State(object, ...)

\method{State}{MSGARCH_SPEC}(object, par, data, ...)

\method{State}{MSGARCH_ML_FIT}(object, newdata = NULL, ...)

\method{State}{MSGARCH_MCMC_FIT}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{State}.}

\item{par}{Vector (of size d) or matrix (of size \code{nmcmc} x d) of parameter estimates
where d must have
the same length as the default parameters of the specification.}

\item{data}{Vector (of size T) of observations.}

\item{newdata}{Vector (of size T*) of new observations. (Default \code{newdata = NULL})}
}
\value{
A list of class \code{MSGARCH_PSTATE} with the following elements:
\itemize{
\item \code{FiltProb}: Filtered probabilities (array of size (T + T*) x (\code{nmcmc or 1}) x K).
\item \code{PredProb}: Predictive probabilities (array of size (T + T* + 1) x (\code{nmcmc or 1}) x K).
\item \code{SmoothProb}: Smoothed probabilities (array of size (T + T* + 1) x (\code{nmcmc or 1}) x K).
\item \code{Viterbi}:  Most likely path (matrix of size (T + T*) x (\code{nmcmc} or 1)).
}
The class \code{MSGARCH_PSTATE} contains the \code{plot} method. The plot method contains
as input \code{type.prob} which is one of \code{"filtered", "predictive", "smoothed", "viterbi"}.
(Default: \code{type.prob = "smoothed"})
}
\description{
Method returning the filtered, predictive, and smoothed probabilities of the states,
and the most probable path computed with the Viterbi algorithm.
}
\details{
If a matrix of parameter estimates is given, each parameter
estimate (each row) is evaluated individually.
}
\examples{
# create specification
spec <- CreateSpec()

# load data
data("SMI", package = "MSGARCH")

# state from specification
par <- c(0.1, 0.1, 0.8, 0.2, 0.1, 0.8, 0.99, 0.01)
state <- State(object = spec, par = par, data = SMI)
plot(state, type.prob = "filtered")

# state from ML fit
fit <- FitML(spec = spec, data = SMI)
state <- State(object = fit)
plot(state, type.prob = "smoothed")

\dontrun{
# state from MCMC fit
set.seed(1234)
fit <- FitMCMC(spec = spec, data = SMI)
state <- State(object = fit)
plot(state, type.prob = "smoothed")
}
}
