% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{combine_stat}
\alias{combine_stat}
\title{Combine p-values}
\usage{
combine_stat(stats, params, type)
}
\arguments{
\item{stats}{A (\code{l x 4}) matrix where \code{l} is the number of moment-based test statistics.}

\item{params}{A (\code{2 x 4}) matrix with parameters to combine test statistics. See \code{\link{approxDistDL}}.}

\item{type}{String determining the type of method used to combine p-values. If set to "min" the min method of combining p-values 
is used as in Fisher 1932 and Pearson 1933. If set to "prod" the product of p-values is used as in Tippett 1931 and Wilkinson 1951.}
}
\value{
A (\code{N x 1}) vector with test statistics. The last element is the test statistic from observed data.
}
\description{
This function is used to combine the four moment-based p-values as in eq. \code{17} and \code{18} of Dufour & Luger 2017.
}
\references{
Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.

Tippett, L. 1931. "The Method of Statistics". London: Williams & Norgate.

Wilkinson, B. 1951. "A statistical consideration in psychological research." \emph{Psychology Bulletin} 48:156–158.

Pearson, K. 1933. "On a method of determining whether a sample of size n
 supposed to have been drawn from a parent population having a known probability integral has probably been drawn at random". \emph{Biometrika} 25:379–410.

Fisher, R. 1932. "Statistical Methods for Research Workers." Edinburgh: Oliver and Boyd.
}
\keyword{internal}
