% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{initVals_MSARXmdl}
\alias{initVals_MSARXmdl}
\title{Initial values for Markov-switching ARX model}
\usage{
initVals_MSARXmdl(mdl, k)
}
\arguments{
\item{mdl}{List with parameter values of simple (one-regime) autoregressive model. This includes:
\itemize{
  \item phi: Vector autoregressive coefficients.
  \item mu: Mean of process.
  \item betaZ: vector of coefficients for exogenous regressors
  \item stdev: Standard deviation.
  \item msmu: Boolean indicator. If \code{TRUE}, mean is function of markov process. If \code{FALSE}, mean is constant across regimes.
  \item msvar: Boolean indicator. If \code{TRUE}, standard deviation is function of markov process. If \code{FALSE}, standard deviation is constant across regimes.
}}

\item{k}{Number of regimes.}
}
\value{
Vector of initial parameter values.
}
\description{
This function generates a random parameter vector to be used as initial values for a Markov-switching ARX model.
}
\keyword{internal}
