% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAD.R
\name{LAD}
\alias{LAD}
\title{Least Absolute Deviance Estimator for Linear Regression}
\usage{
LAD(X, y, intercept = FALSE)
}
\arguments{
\item{X}{design matrix}

\item{y}{reponse vector}

\item{intercept}{logical input that indicates if intercept needs to be estimated. Default is FALSE.}
}
\value{
coefficient estimates
}
\description{
Least Absolute Deviance Estimator for Linear Regression
}
\examples{
set.seed(1989)
n=200; d=4
X=matrix(rnorm(n*d), nrow=n, ncol=d)
beta=c(1, -1, 2, -2)
y=-2+X\%*\%beta+c(rnorm(150), rnorm(30,10,10), rnorm(20,0,100))
beta.ls=lm(y~X)$coeff
beta.LAD=LAD(X,y,intercept=TRUE)
cbind(c(-2,beta), beta.ls, beta.LAD)

}
