% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{calibration}
\alias{calibration}
\title{Model Calibration}
\usage{
calibration(x, n = 10, ...)
}
\arguments{
\item{x}{Resamples object.}

\item{n}{number of resampled response variable bins within which to
calculate observed mean values.}

\item{...}{arguments passed to other methods.}
}
\value{
ResamplesCalibration class object.
}
\description{
Calculate calibration estimates from observed and resampled response variable
values.
}
\examples{
library(survival)
library(MASS)

perf <- resample(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
                 data = Melanoma, model = GBMModel,
                 control = CVControl(surv_times = 365 * c(2, 5, 10)))
(cal <- calibration(perf))
plot(cal)

}
\seealso{
\code{\link{resample}}, \code{\link{plot}}
}
