% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{calibration}
\alias{calibration}
\alias{Calibration}
\title{Model Calibration}
\usage{
Calibration(...)

calibration(x, y = NULL, breaks = 10, span = 0.75, dist = NULL,
  na.rm = TRUE, ...)
}
\arguments{
\item{...}{named or unnamed \code{calibration} output to combine together
with the \code{Calibration} constructor.}

\item{x}{observed responses or \code{Resamples} object of observed and
predicted responses.}

\item{y}{predicted responses.}

\item{breaks}{value defining the response variable bins within which to
calculate observed mean values.  May be specified as a number of bins, a
vector of breakpoints, or \code{NULL} to fit smooth curves with splines for
predicted survival probabilities and with \link[stats:loess]{loess} for
others.}

\item{span}{numeric parameter controlling the degree of loess smoothing.}

\item{dist}{character string specifying a distribution with which to estimate
observed survival means.  Possible values are \code{"empirical"} for the
Kaplan-Meier estimator, \code{"exponential"}, \code{"extreme"},
\code{"gaussian"}, \code{"loggaussian"}, \code{"logistic"},
\code{"loglogistic"}, \code{"lognormal"}, \code{"rayleigh"}, \code{"t"}, or
\code{"weibull"} (default).}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}
}
\value{
\code{Calibration} class object that inherits from \code{data.frame}.
}
\description{
Calculate calibration estimates from observed and predicted responses.
}
\examples{
library(survival)
library(MASS)

res <- resample(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
                data = Melanoma, model = GBMModel,
                control = CVControl(times = 365 * c(2, 5, 10)))
cal <- calibration(res)
plot(cal)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{plot}}
}
