% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit}
\alias{fit}
\alias{fit.formula}
\alias{fit.matrix}
\alias{fit.ModelFrame}
\alias{fit.recipe}
\title{Model Fitting}
\usage{
fit(x, ...)

\method{fit}{formula}(x, data, model, ...)

\method{fit}{matrix}(x, y, model, ...)

\method{fit}{ModelFrame}(x, model, ...)

\method{fit}{recipe}(x, model, ...)
}
\arguments{
\item{x}{defines a relationship between model predictor and response
variables.  May be a \code{formula}, design matrix of predictors,
\code{ModelFrame}, or untrained \code{recipe}.}

\item{...}{arguments passed to other methods.}

\item{data}{\code{data.frame} containing observed predictors and outcomes.}

\item{model}{\code{MLModel} object, constructor function, or character string
naming a constructor function that returns an \code{MLModel} object.}

\item{y}{predictor variable.}
}
\value{
\code{MLModelFit} class object.
}
\description{
Fit a model to estimate its parameters from a data set.
}
\details{
User-specified case weights may be specified for
\code{\link[=ModelFrame]{ModelFrames}} upon creation with the \code{weights}
argument in its constructor.

Variables in a \code{recipe} may be used as case weights by defining a
"case_weight" \code{\link[recipes:roles]{role}} for them.
}
\examples{
## Survival response example
library(survival)
library(MASS)

gbmfit <- fit(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
              data = Melanoma, model = GBMModel)
varimp(gbmfit)

}
\seealso{
\code{\link{ModelFrame}}, \code{\link[recipes]{recipe}},
\code{\link{models}}, \code{\link{tune}}, \code{\link{predict}},
\code{\link{varimp}}
}
