% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLModel.R
\name{MLModel}
\alias{MLModel}
\title{MLModel Class Constructor}
\usage{
MLModel(
  name = "MLModel",
  label = name,
  packages = character(),
  response_types = character(),
  weights = FALSE,
  predictor_encoding = c(NA, "model.frame", "model.matrix"),
  params = list(),
  gridinfo = tibble::tibble(param = character(), get_values = list(), default =
    logical()),
  fit = function(formula, data, weights, ...) stop("No fit function."),
  predict = function(object, newdata, times, ...) stop("No predict function."),
  varimp = function(object, ...) NULL,
  ...
)
}
\arguments{
\item{name}{character name of the object to which the model is assigned.}

\item{label}{optional character descriptor for the model.}

\item{packages}{character vector of package names upon which the model
depends.  Each name may be optionally followed by a comment in
parentheses specifying a version requirement.  The comment should contain
a comparison operator, whitespace and a valid version number, e.g.
\code{"xgboost (>= 1.3.0)"}.}

\item{response_types}{character vector of response variable types to which
the model can be fit.  Supported types are \code{"binary"}, =
\code{"BinomialVariate"}, \code{"DiscreteVariate"}, \code{"factor"},
\code{"matrix"}, \code{"NegBinomialVariate"}, \code{"numeric"},
\code{"ordered"}, \code{"PoissonVariate"}, and \code{"Surv"}.}

\item{weights}{logical value or vector of the same length as
\code{response_types} indicating whether case weights are supported for
the responses.}

\item{predictor_encoding}{character string indicating whether the model is
fit with predictor variables encoded as a \code{"\link{model.frame}"},
a \code{"\link{model.matrix}"}, or unspecified (default).}

\item{params}{list of user-specified model parameters to be passed to the
\code{fit} function.}

\item{gridinfo}{tibble of information for construction of tuning grids
consisting of a character column \code{param} with the names of parameters
in the grid, a list column \code{get_values} with functions to generate grid
points for the corresponding parameters, and an optional logical column
\code{default} indicating which parameters to include by default in regular
grids.  Values functions may optionally include arguments \code{n} and
\code{data} for the number of grid points to generate and a
\code{\link{ModelFrame}} of the model fit data and formula, respectively;
and must include an ellipsis (\code{...}).}

\item{fit}{model fitting function whose arguments are a \code{formula}, a
\code{\link{ModelFrame}} named \code{data}, case \code{weights}, and an
ellipsis.}

\item{predict}{model prediction function whose arguments are the
\code{object} returned by \code{fit}, a \code{\link{ModelFrame}} named
\code{newdata} of predictor variables, optional vector of \code{times} at
which to predict survival, and an ellipsis.}

\item{varimp}{variable importance function whose arguments are the
\code{object} returned by \code{fit}, optional arguments passed from calls
to \code{\link{varimp}}, and an ellipsis.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{MLModel} class object.
}
\description{
Create a model for use with the \pkg{MachineShop} package.
}
\details{
If supplied, the \code{grid} function should return a list whose elements are
named after and contain values of parameters to include in a tuning grid to
be constructed automatically by the package.

Arguments \code{data} and \code{newdata} in the \code{fit} and \code{predict}
functions may be converted to data frames with \code{as.data.frame()}
if needed for their operation.  The \code{fit} function should return the
object resulting from the model fit.  Values returned by the \code{predict}
functions should be formatted according to the response variable types below.
\describe{
  \item{factor}{vector or column matrix of probabilities for the second level
    of binary factors or a matrix whose columns contain the probabilities for
    factors with more than two levels.}
  \item{matrix}{matrix of predicted responses.}
  \item{numeric}{vector or column matrix of predicted responses.}
  \item{Surv}{matrix whose columns contain survival probabilities at
    \code{times} if supplied or a vector of predicted survival means
    otherwise.}
}

The \code{varimp} function should return a vector of importance values named
after the predictor variables or a matrix or data frame whose rows are named
after the predictors.
}
\examples{
## Logistic regression model
LogisticModel <- MLModel(
  name = "LogisticModel",
  response_types = "binary",
  weights = TRUE,
  fit = function(formula, data, weights, ...) {
    glm(formula, data = as.data.frame(data), weights = weights,
        family = binomial, ...)
  },
  predict = function(object, newdata, ...) {
    predict(object, newdata = as.data.frame(newdata), type = "response")
  },
  varimp = function(object, ...) {
    pchisq(coef(object)^2 / diag(vcov(object)), 1)
  }
)

data(Pima.tr, package = "MASS")
res <- resample(type ~ ., data = Pima.tr, model = LogisticModel)
summary(res)

}
\seealso{
\code{\link{models}}, \code{\link{fit}}, \code{\link{resample}}
}
