% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLMetric.R
\name{MLMetric}
\alias{MLMetric}
\alias{MLMetric<-}
\title{MLMetric Class Constructor}
\usage{
MLMetric(object, name = "MLMetric", label = name, maximize = TRUE)

MLMetric(object) <- value
}
\arguments{
\item{object}{function to compute the metric, defined to accept
\code{observed} and \code{predicted} as the first two arguments and with an
ellipsis (\code{...}) to accommodate others.}

\item{name}{character name of the object to which the metric is assigned.}

\item{label}{optional character descriptor for the model.}

\item{maximize}{logical indicating whether higher values of the metric
correspond to better predictive performance.}

\item{value}{list of arguments to pass to the \code{MLMetric} constructor.}
}
\value{
\code{MLMetric} class object.
}
\description{
Create a performance metric for use with the \pkg{MachineShop} package.
}
\examples{
f2_score <- MLMetric(
  function(observed, predicted, ...) {
    f_score(observed, predicted, beta = 2, ...)
  },
  name = "f2_score",
  label = "F Score (beta = 2)",
  maximize = TRUE
)

}
\seealso{
\code{\link{metrics}}
}
