% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_SuperModel.R
\name{SuperModel}
\alias{SuperModel}
\title{Super Learner Model}
\usage{
SuperModel(
  ...,
  model = GBMModel,
  control = MachineShop::settings("control"),
  all_vars = FALSE
)
}
\arguments{
\item{...}{\link[=models]{model} functions, function names, objects; other
objects that can be \link[=as.MLModel]{coerced} to models; or vector of
these to serve as base learners.}

\item{model}{\link[=models]{model} function, function name, or object
defining the super model; or another object that can be
\link[=as.MLModel]{coerced} to the model.}

\item{control}{\link[=controls]{control} function, function name, or object
defining the resampling method to be employed for the estimation of base
learner weights.}

\item{all_vars}{logical indicating whether to include the original
predictor variables in the super model.}
}
\value{
\code{SuperModel} class object that inherits from \code{MLModel}.
}
\description{
Fit a super learner model to predictions from multiple base learners.
}
\details{
\describe{
  \item{Response types:}{\code{factor}, \code{numeric}, \code{ordered},
    \code{Surv}}
}
}
\examples{
\donttest{
## Requires prior installation of suggested packages gbm and glmnet to run

model <- SuperModel(GBMModel, SVMRadialModel, GLMNetModel(lambda = 0.01))
model_fit <- fit(sale_amount ~ ., data = ICHomes, model = model)
predict(model_fit, newdata = ICHomes)
}

}
\references{
van der Laan, M. J., Polley, E. C., & Hubbard, A. E. (2007). Super learner.
\emph{Statistical Applications in Genetics and Molecular Biology},
\emph{6}(1).
}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
