% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utliMWRoutlier.R
\name{utilMWRoutlier}
\alias{utilMWRoutlier}
\title{Identify outliers in a numeric vector}
\usage{
utilMWRoutlier(x, logscl)
}
\arguments{
\item{x}{numeric vector of any length}

\item{logscl}{logical to indicate if vector should be log10-transformed first}
}
\value{
A logical vector equal in length to \code{x} indicating \code{TRUE} for outliers or \code{FALSE} for within normal range
}
\description{
Identify outliers in a numeric vector
}
\details{
Outliers are identified as 1.5 times the interquartile range
}
\examples{
x <- rnorm(20)
utilMWRoutlier(x, logscl = FALSE)
}
