% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.wimids.R
\name{plot.wimids}
\alias{plot.wimids}
\title{Plots a \code{wimids} Class Object}
\usage{
\method{plot}{wimids}(x, n = 1, type = "QQ", discrete.cutoff = 5,
  numdraws = 5000, interactive = TRUE, which.xs = NULL, ...)
}
\arguments{
\item{x}{This argument specifies an object of the \code{wimids} class.}

\item{n}{This argument specifies the weighted imputed dataset number, intended to plot its matching profile. The input must be a positive integer. The default is \code{1}.}

\item{type}{This argument specifies type of the plot. Currently, \code{"QQ"} (the empirical quantile-quantile plots of each covariate to check balance of marginal distributions), \code{"jitter"} (the jitter plots of the propensity score for control and treatment observations), and \code{"hist"} (the histograms of the propensity score in the original control and treatment groups) types are available. The default is \code{"QQ"}.}

\item{discrete.cutoff}{This argument specifies number of values of covariates that are jittered for visibility (for quantile-quantile plots). The input must be a positive integer. The default is \code{5}, meaning that discrete covariates that take 5 or fewer values are jittered.}

\item{numdraws}{This argument specifies number of observations that are sampled for plotting full or ratio matching (using weights). The input must be a positive integer. The default is \code{5000}.}

\item{interactive}{This argument specifies whether users can identify observations by clicking on the graph with the left mouse button and (when applicable) choose subclasses to plot. The input must be a logical value. The default is \code{TRUE}.}

\item{which.xs}{This argument specifies particular covariate names in a character vector to plot only a subset of the covariates (for quantile-quantile plots). The default is \code{"NULL"}.}

\item{...}{Additional arguments to be passed to the \code{plot.wimids()} function.}
}
\description{
The \code{plot.wimids()} function plots an object of the \code{wimids} class.
}
\details{
The matching profile of the \code{wimids} class objects is plotted.
}
\examples{
\donttest{
#Loading the 'dt.osa' dataset
data(dt.osa)

#Imputing missing data points in the'dt.osa' dataset
datasets <- mice(dt.osa, m = 5, maxit = 1,
                 method = c("", "", "mean", "", "polyreg", "logreg", "logreg"))

#Weighting the imputed datasets, 'datasets'
weighteddatasets <- weightitmice(KOA ~ SEX + AGE + SMK, datasets,
                                 approach = 'within', method = 'nearest')

#Plotting data of the first imputed dataset
plot.1 <- plot(weighteddatasets, n = 1)
}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=wimids]{wimids}}
}
\author{
Farhad Pishgar
}
\keyword{function}
