% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{conversions}
\alias{conversions}
\alias{as.csr.matrix}
\alias{as.csc.matrix}
\alias{as.coo.matrix}
\alias{as.sparse.vector}
\title{Conversions between matrix types}
\usage{
as.csr.matrix(x, binary = FALSE, logical = FALSE, sort = FALSE)

as.csc.matrix(x, binary = FALSE, logical = FALSE, sort = FALSE)

as.coo.matrix(x, binary = FALSE, logical = FALSE, sort = FALSE)

as.sparse.vector(x, binary = FALSE, logical = FALSE, integer = FALSE)
}
\arguments{
\item{x}{A matrix which is to be converted to a different format.

Supported input types are:\itemize{
\item Sparse matrices from `Matrix` package, in any format.
\item Sparse vectors from `Matrix` in any format.
\item Dense matrices from base R (class `matrix`).
\item Dense vectors from base R (classes `numeric`, `integer`, `logical`).
\item Dense matrix or vector from package `float` (class `float32`).
\item `data.frame`, `data.table`, and `tibble`.
}}

\item{binary}{Whether the result should be a binary-only matrix/vector (inheriting from
class `nsparseMatrix`/`nsparseVector` - these don't have slot `x`).
Can only pass one of `binary` or `logical`.}

\item{logical}{Whether the result should be a matrix/vector with logical (boolean) type
(inheriting from `lsparseMatrix`/`lsparseVector`).
Can only pass one of `binary` or `logical`.}

\item{sort}{Whether to sort the indices in case they are not sorted. Note that it will
perform deep copies of the indices and values along the way.}

\item{integer}{Whether the result should be a vector with integer type ('isparseVector').}
}
\value{
A sparse matrix/vector, with format:\itemize{
\item CSR (a.k.a. `RsparseMatrix`) when calling `as.csr.matrix`
(class `dgRMatrix`, `ngRMatrix`, or `lgRMatrix`, depending on parameters `binary` and `logical`).
\item CSC (a.k.a. `CsparseMatrix`) when calling `as.csc.matrix`
(class `dgCMatrix`, `ngCMatrix`, or `lgCMatrix`, depending on parameters `binary` and `logical`).
\item COO (a.k.a. `TsparseMatrix`) when calling `as.coo.matrix`
(class `dgTMatrix`, `ngTMatrix`, or `lgTMatrix`, depending on parameters `binary` and `logical`).
\item sparse vector (class dependant on input) when calling `as.sparse.vector`.
}
}
\description{
Convenience functions for converting to different sparse matrix formats,
between pairs of classes which might not be supported in the `Matrix` package.

These come in the form of explicit functions 'as.<type>.matrix' (see below),
as well as registered conversion methods to use along with `as(object, type)`, adding
extra conversion routes which are missing in the `Matrix` package for output
types `dgRMatrix`, `lgRMatrix`, and `ngRMatrix`.
}
\details{
The functions internally might use some routes of `as(x, "?sparseMatrix")`, so they might work
with other object classes if they register a conversion method for `Matrix` base
types.

When passed a vector, the functions `as.csr.matrix` and `as.coo.matrix` will
assume that it is a row vector, while `as.csc.matrix` will assume it's a column vector.
}
\examples{
library(Matrix)
library(MatrixExtra)

m.coo <- as(matrix(1:3), "TsparseMatrix")
as.csr.matrix(m.coo)
as.csr.matrix(1:3) # <- assumes it's a row vector
as.csc.matrix(1:3) # <- assumes it's a column vector

### Using the new conversion methods
### (these would fail if 'MatrixExtra' is not loaded)
as(matrix(1:3), "ngRMatrix")
as(as.csc.matrix(m.coo), "dgRMatrix")
}
