% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_combine.R
\name{sts_combine}
\alias{sts_combine}
\title{Combine multiple \emph{sts} time series objects}
\usage{
sts_combine(..., replaceMeta = FALSE)
}
\arguments{
\item{...}{Any number of valid SingleTimeSeries \emph{sts} objects associated
with a single \code{deviceDeploymentID}.}

\item{replaceMeta}{Logical specifying whether to allow replacement of
metadata.}
}
\value{
A SingleTimeSeries \emph{sts} time series object containing
records from all incoming \code{sts} time series objects.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Create a merged timeseries using of any number of \emph{sts}
objects for a single sensor. If \emph{sts} objects are non-contiguous, the
resulting \emph{sts} will have gaps.

An error is generated if the incoming \emph{sts} objects have
non-identical \code{deviceDeploymentIDs}.
}
\note{
Data are combined with a "later is better" sensibility where any
data overlaps exist. To handle this, incoming \emph{sts} objects are first
split into "shared" and "unshared" parts.

Any "shared" parts are ordered based on the
time stamp of their last record. Then \code{dplyr::distinct()} is used to
remove records with duplicate \code{datetime} fields. Any data records found
in "later" \emph{sts} objects are preferentially retained before the "shared"
data are finally reordered by ascending \code{datetime}.

The final step is combining the "shared" and "unshared" parts.
}
\examples{
library(MazamaTimeSeries)

aug01_08 <-
  example_sts \%>\%
  sts_filterDate(20180801, 20180808)

aug15_22 <-
  example_sts \%>\%
  sts_filterDate(20180815, 20180822)

aug01_22 <- sts_combine(aug01_08, aug15_22)

plot(aug01_22$data$datetime)
}
