% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{example_raws}
\alias{example_raws}
\title{Example RAWS dataset}
\format{
An \emph{sts} object composed of "meta" and "data" dataframes.
}
\usage{
example_raws
}
\description{
The \code{example_raws} dataset provides a quickly loadable
example of the data generated by the **RAWSmet** package. This data is a
\code{sts} object containing hourly measurements from a RAWS weather station
in Saddle Mountain, WA, between July 2002 and December 2017.

This dataset was was generated on 2022-02-17 by running:

\preformatted{
library(RAWSmet)

setRawsDataDir("~/Data/RAWS")

example_raws <-
  cefa_load(nwsID = "452701") %>%
  raws_filterDate(20160701, 20161001)

save(example_raws, file = "data/example_raws.rda")
}
}
\keyword{datasets}
