% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMeasurementTimings.R
\name{tableMeasurementTimings}
\alias{tableMeasurementTimings}
\title{Format a measurement_timings object into a visual table}
\usage{
tableMeasurementTimings(
  result,
  type = "gt",
  header = c(visOmopResults::strataColumns(result)),
  groupColumn = c("codelist_name"),
  settingsColumn = character(),
  hide = c("variable_level"),
  style = "default",
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Type of table. Check supported types with
`visOmopResults::tableType()`.}

\item{header}{Columns to use as header. See options with
`visOmopResults::tableColumns(result)`.}

\item{groupColumn}{Columns to group by. See options with
`visOmopResults::tableColumns(result)`.}

\item{settingsColumn}{Columns from settings to include in results. See
options with `visOmopResults::settingsColumns(result)`.}

\item{hide}{Columns to hide from the visualisation. See options with
`visOmopResults::tableColumns(result)`.}

\item{style}{Named list that specifies how to style the different parts of
the table generated. It can either be a pre-defined style ("default" or
"darwin" - the latter just for gt and flextable), NULL to get the table type
default style, or custom. Keep in mind that styling code is different for
all table styles. To see the different styles use visOmopResults::tableStyle().}

\item{.options}{A named list with additional formatting options.
`visOmopResults::tableOptions()` shows allowed arguments and their default values.}
}
\value{
A formatted table
}
\description{
Format a measurement_timings object into a visual table
}
\examples{
\donttest{
library(MeasurementDiagnostics)
cdm <- mockMeasurementDiagnostics()
result <- summariseMeasurementUse(
              cdm = cdm,
              codes = list("test_codelist" = c(3001467L, 45875977L)))
tableMeasurementTimings(result)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
