% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Meiosis.R
\name{realized_coancestry}
\alias{realized_coancestry}
\title{Compute co-ancestry}
\usage{
realized_coancestry(individual_1, individual_2 = NULL, check = FALSE)
}
\arguments{
\item{individual_1}{List. A first Individual in segmental representation.}

\item{individual_2}{List. A second Individual in segmental representation.
If \code{NULL}, self-co-ancestry of \code{individual_1} is computed.}

\item{check}{Logical. Should checks be performed?}
}
\value{
Double. Realized coefficient of co-ancestry.
}
\description{
Compute the realized coefficient of co-ancestry between two individuals.
}
\details{
The realized coefficient of co-ancestry is (herein) defined as the probability
that two alleles randomly drawn from one of the homologous chromosomes, each from one of the
individuals, are identical-by-descent (as specified by origins of founder alleles).
}
\examples{
\dontrun{
data(exdat, package = 'Meiosis')
Meiosis::realized_coancestry(Meiosis::dh_xo(exdat$founder, exdat$xoparam),
                             Meiosis::dh_xo(exdat$founder, exdat$xoparam))
}

}
