% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{WeightedMedian-class}
\alias{WeightedMedian-class}
\title{WeightedMedian Class}
\description{
An object containing the estimate produced using the median-based method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Type}}{The type of median that has been calculated, \code{"simple"}, \code{"weighted"}, or \code{"penalized"}.}

\item{\code{Exposure}}{The name of the exposure variable.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Estimate}}{The causal point estimate from the median-based method.}

\item{\code{StdError}}{The standard error associated with \code{Estimate} (obtained from bootstrapping).}

\item{\code{CILower}}{The lower bound of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bound of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{Pvalue}}{P-value associated with the causal estimate from the Wald method.}

\item{\code{SNPs}}{The number of SNPs that used in the calculation.}
}}

