% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MaxLik-class}
\alias{MaxLik-class}
\title{MaxLik Class}
\description{
An object containing the estimate produced using the maximum-likelihood method as well as various statistics.
}
\section{Slots}{

\describe{
\item{\code{Model}}{The model used for estimation: fixed-effect (\code{"fixed"}) or random-effects (\code{"random"}).}

\item{\code{Exposure}}{The name of the exposure variable.}

\item{\code{Outcome}}{The name of the outcome variable.}

\item{\code{Correlation}}{The matrix of correlations between genetic variants.}

\item{\code{Psi}}{The correlations between genetic associations with the exposure and with the outcome.}

\item{\code{Estimate}}{The causal point estimate from the inverse-variance weighted method.}

\item{\code{StdError}}{The standard error associated with \code{Estimate}.}

\item{\code{CILower}}{The lower bound of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{CIUpper}}{The upper bound of the confidence interval for \code{Estimate} based on \code{StdError}.}

\item{\code{Alpha}}{The significance level used in constructing the confidence interval (default is 0.05).}

\item{\code{Pvalue}}{P-value associated with the causal estimate.}

\item{\code{SNPs}}{The number of SNPs that were used in the calculation.}

\item{\code{RSE}}{The estimated residual standard error from the regression model.}

\item{\code{Heter.Stat}}{Heterogeneity statistic (likelihood ratio statistic) and associated p-value: the null hypothesis is that all genetic variants estimate the same causal parameter; rejection of the null is an indication that one or more variants may be pleiotropic.}
}}

