% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_extended.R
\name{doAdduct}
\alias{doAdduct}
\title{Generate adduct for given structure}
\usage{
doAdduct(structure, formula, charge, adduct_table, query_adduct)
}
\arguments{
\item{structure}{SMILES structure}

\item{formula}{Molecular formula}

\item{charge}{Initial charge}

\item{adduct_table}{Adduct table}

\item{query_adduct}{Adduct 'Name' of interest}
}
\value{
Table with adducts of this compound
}
\description{
Takes in formula, an adduct of interest, and returns adduct formulas and charges.
}
\examples{
 data(adduct_rules)
 data(adducts)
 structure = 'OC[C@H]1OC(O)[C@H](O)[C@H](O)[C@H]1O'
 doAdduct(structure = structure, formula="C6H12O6", charge=0,
 adduct_table=adducts, query_adduct="[M+H]1+")
}
\seealso{
\code{\link[enviPat]{check_chemform}},\code{\link[enviPat]{mergeform}},\code{\link[enviPat]{check_ded}},\code{\link[enviPat]{subform}},\code{\link[enviPat]{multiform}}
}
