% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lincsTools.R
\name{lincsBaitCorr}
\alias{lincsBaitCorr}
\title{Run Shane's LINCS bait-based correlation on MetaIntegrator}
\usage{
lincsBaitCorr(metaObject, filterObject, dataset = "CP", baits,
  just_clin = F, hit.number.hm = 20, hm_baits = T,
  direction = "aggravate", bait_type = NULL)
}
\arguments{
\item{metaObject}{a Meta object which must have the $originalData populated}

\item{filterObject}{a MetaFilter object containing the signature genes that will be used for calculating the score}

\item{dataset}{The LINCS dataset to use. One of "CP" (drugs),"SH" (shRNA),"OE" (over-expression),
"LIG" (ligands),"MUT" (mutants) (default: CP)}

\item{baits}{vector containing names of the baits being used (relevant drugs, shRNAs, etc.). See example.}

\item{just_clin}{only consider clinically relevant results (default: FALSE)}

\item{hit.number.hm}{How many hits to show in a heatmap (default: 20)}

\item{hm_baits}{whether or not to include the baits in the heatmap (default: FALSE)}

\item{direction}{one of "reverse", "aggravate", or "absolute" (default: "reverse") 
for whether you want to reverse the signature, aggravate it, or just want the top absolute hits.}

\item{bait_type}{The LINCS dataset where the baits come from. 
One of "CP" (drugs),"SH" (shRNA),"OE" (over-expression),
"LIG" (ligands),"MUT" (mutants), or NULL (don't specify) (default:NULL)}
}
\value{
The full list of correlations as well as the dataframe with the expression of the top hits.
Also generates the heatmap of the top hits.
}
\description{
LINCS Bait Corr finds perturbagens similar to a set of interest, called baits.  
It searches within a defined sub space of relevant genes, usually a disease signature
See below for an example that recreates the work we did to find the antiviral drugs
}
\examples{
\dontrun{
####### DATA SETUP ##########
# Example won't work on tinyMetaObject because it requires real gene names
# Download the needed datasets for processing. 
sleData <- getGEOData(c("GSE11909","GSE50635", "GSE39088"))

#Label classes in the datasets
sleData$originalData$GSE50635 <- classFunction(sleData$originalData$GSE50635, 
  column = "subject type:ch1", diseaseTerms = c("Subject RBP +", "Subject RBP -"))
sleData$originalData$GSE11909_GPL96 <- classFunction(sleData$originalData$GSE11909_GPL96, 
   column = "Illness:ch1", diseaseTerms = c("SLE"))
sleData$originalData$GSE39088 <- classFunction(sleData$originalData$GSE39088, 
   column= "disease state:ch1", diseaseTerms=c("SLE"))
 #Remove the GPL97 platform that was downloaded
sleData$originalData$GSE11909_GPL97 <- NULL

#Run Meta-Analysis
sleMetaAnalysis <- runMetaAnalysis(sleData, runLeaveOneOutAnalysis = F, maxCores = 1)

#Filter genes
sleMetaAnalysis <- filterGenes(sleMetaAnalysis, isLeaveOneOut = F, 
   effectSizeThresh = 1, FDRThresh = 0.05)
####### END DATA SETUP ##########

#Note: these are note relevant baits for SLE, just examples
 lincsBaitCorr(metaObject = sleMetaAnalysis, filterObject = sleMetaAnalysis$filterResults[[1]], 
   dataset = "CP", baits = c("NICLOSAMIDE","TYRPHOSTINA9","DISULFIRAM","SU4312","RESERPINE"))
 }

}
