% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassificationWrapper.R
\name{ClassificationWrapper}
\alias{ClassificationWrapper}
\title{ClassificationWrapper.}
\usage{
ClassificationWrapper(d = NULL, g = NULL, n = 100, k = 5,
  method = c("C50", "svm", "rpart"), train = NULL, rpart.control = list())
}
\arguments{
\item{d}{data, matrix or data.frame !! needs row/col-names.}

\item{g}{Group-vector, factor.}

\item{n}{replicates of classifications.}

\item{k}{Fold cross validation.}

\item{method}{Currently \code{svm} and decison tree methods \code{C50} and \code{rpart} are supported.}

\item{train}{Either NULL (random permutations) or an index vector for a training subset out of \code{g}.}

\item{rpart.control}{Forwarded to rpart.}
}
\value{
Classification results as list.
}
\description{
\code{ClassificationWrapper} will do classification using SVM's and/or Decision Trees including cross validation.
}
\details{
not yet
}
\examples{
utils::data(raw, package = "MetabolomicsBasics")
utils::data(sam, package = "MetabolomicsBasics")
gr <- sam$Origin

# establish a basic rpart model and render a fancy plot including the accuracy
class_res <- ClassificationWrapper(d=raw, g=gr, method="rpart", n=10)
\donttest{
class_res <- ClassificationWrapper(d=raw, g=gr, method=c("rpart","svm"))
}

}
