% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_boundaries.R
\name{find_boundaries}
\alias{find_boundaries}
\title{find_boundaries.}
\usage{
find_boundaries(
  int = NULL,
  rt = NULL,
  p = which.max(int),
  k = 3,
  bl = min(int),
  local_min = int[p]
)
}
\arguments{
\item{int}{The measured intensity of the ion mass (obviously ordered according to consecutive RTs).}

\item{rt}{The respective retention times (can be omitted as currently not used).}

\item{p}{The anticipated peak position (as index of int) if several peaks are within the mass trace.}

\item{k}{The smoothing window parameter (provided to runmed).}

\item{bl}{The baseline value. Can be provided explicitly if automatic determination is insufficient.}

\item{local_min}{This is practically the upper end of the baseline. It can be set to avoid boundary detection at local minima (e.g. for peaks suffering ion suppression).}
}
\value{
Numeric vector of length=2 specifying the start and end index of the peak.
}
\description{
\code{find_boundaries} will determine peak boundaries within a BPC or mass trace.
}
\details{
It is yet another peak finder or, more precisely, it is a function
  to identify two RT values which flank a intensity maximum which is required
  if one would like to integrate the peak area.
}
\examples{
int <- sin(seq(-0.75 * pi, 1.75 * pi, by = 0.1))
plot(int)
abline(v = find_boundaries(int = int))
}
