% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_retrieval.R
\name{mapk}
\alias{mapk}
\title{Mean Average Precision at k}
\usage{
mapk(k, actual, predicted)
}
\arguments{
\item{k}{The number of elements of \code{predicted} to consider in the calculation.}

\item{actual}{A list of vectors, where each vector represents a ground truth vector
of relevant documents. In each vector, the elements can be numeric
or character values, and the order of the elements does not matter.}

\item{predicted}{A list of vectors, where each vector represents the predicted vector
of retrieved documents for the corresponding element of \code{actual}.
In each vector, the order of the elements does matter, with the
elements believed most likely to be relevant at the beginning.}
}
\description{
\code{mapk} computes the mean average precision at k for a set of predictions, in
the context of information retrieval problems.
}
\details{
\code{mapk} evaluates \code{apk} for each pair of elements from \code{actual} and
\code{predicted}.
}
\examples{
actual <- list(c('a', 'b'), c('a'), c('x', 'y', 'b'))
predicted <- list(c('a', 'c', 'd'), c('x', 'b', 'a', 'b'), c('y'))
mapk(2, actual, predicted)

actual <- list(c(1, 5, 7, 9), c(2, 3), c(2, 5, 6))
predicted <- list(c(5, 6, 7, 8, 9), c(1, 2, 3), c(2, 4, 6, 8))
mapk(3, actual, predicted)
}
\seealso{
\code{\link{apk}} \code{\link{f1}}
}
