% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f1_score.R
\name{f1_score}
\alias{f1_score}
\title{F1 score}
\usage{
f1_score(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values (0 or 1).}

\item{predicted}{Predicted values (0 or 1).}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{precision} and \code{recall}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted F1 score, the harmonic mean of precision and recall.
}
\examples{
f1_score(c(0, 0, 1, 1), c(0, 0, 1, 1))
f1_score(c(1, 0, 0, 1), c(0, 0, 1, 1))
f1_score(c(1, 0, 0, 1), c(0, 0, 1, 1), w = 1:4)

}
\seealso{
\code{\link{precision}, \link{recall}}.
}
\author{
Michael Mayer, \email{mayermichael79@gmail.com}
}
