% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{roc_surro_subplots}
\alias{roc_surro_subplots}
\title{roc_surro_subplots}
\usage{
roc_surro_subplots(surrogates, bin_phenotypes)
}
\arguments{
\item{surrogates}{numeric data.frame containing the surrogate values by Bizzarri et al.}

\item{bin_phenotypes}{numeric data.frame with the binarized phenotypes output of binarize_all_pheno}
}
\value{
plotly image with all the ROCs for all the available clinical variables
}
\description{
Function that plots the ROCs of the surrogates of all the available surrogate models as plotly sub-plots
}
\examples{
library(pROC)
library(plotly)
library(MiMIR)

#load the dataset
met <- synthetic_metabolic_dataset
phen<- synthetic_phenotypic_dataset

#Calculating the binarized surrogates
b_phen<-binarize_all_pheno(phen)
#Apply a surrogate models and plot the ROC curve
surr<-calculate_surrogate_scores(met, phen, MiMIR::PARAM_surrogates, colnames(b_phen))

roc_surro_subplots(surr$surrogates, b_phen)


}
