% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humans_SIS.R
\name{get_config_humans_SIS}
\alias{get_config_humans_SIS}
\title{Get parameters for SIS human model}
\usage{
get_config_humans_SIS(path)
}
\arguments{
\item{path}{a file path to a JSON file}
}
\value{
a named \link{list}
}
\description{
The JSON config file should have 8 entries:
\itemize{
\item stochastic: a boolean value
\item theta: matrix (row major)
\item wf: vector
\item H: vector
\item X: vector
\item b: scalar
\item c: scalar
\item r: scalar
}

For interpretation of the entries, please read \link{setup_humans_SIS}.
}
\examples{
# to see an example of proper JSON input, run the following
library(jsonlite)
n <- 6 # number of human population strata
p <- 5 # number of patches
theta <- matrix(rexp(n*p), nrow = n, ncol = p)
theta <- theta / rowSums(theta)
H <- rep(10, n)
X <- rep(3, n)
par <- list(
 "stochastic" = FALSE,
 "theta" = theta,
 "wf" = rep(1, n),
 "H" = H,
 "X" = X,
 "b" = 0.55,
 "c" = 0.15,
 "r" = 1/200
)
toJSON(par, pretty = TRUE)
}
