% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{get_sharepoint_site}
\alias{get_sharepoint_site}
\alias{get_drive}
\alias{list_drives}
\title{Get SharePoint site or OneDrive}
\description{
Methods for the \link[AzureGraph:ms_graph]{AzureGraph::ms_graph}, \link[AzureGraph:az_user]{AzureGraph::az_user} and \link[AzureGraph:az_group]{AzureGraph::az_group} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'ms_graph'
get_drive(drive_id)

## R6 method for class 'az_user'
get_drive(drive_id = NULL)

## R6 method for class 'az_group'
get_drive(drive_id = NULL)

## R6 method for class 'ms_graph'
get_sharepoint_site(site_url = NULL, site_id = NULL)

## R6 method for class 'az_group'
get_sharepoint_site()

## R6 method for class 'az_user'
list_drives()

## R6 method for class 'az_group'
list_drives()
}
}

\section{Arguments}{

\itemize{
\item \code{drive_id}: For \code{get_drive}, the ID of the drive or shared document library. For the \code{az_user} and \code{az_group} methods, if this is NULL the default drive/document library is returned.
\item \code{site_url},\code{site_id}: For \code{ms_graph$get_sharepoint_site()}, the URL and ID of the site. Provide one or the other, but not both.
}
}

\section{Details}{

\code{get_sharepoint_site} retrieves a SharePoint site object. The method for the top-level Graph client object requires that you provide either the site URL or ID. The method for an \code{az_group} object will retrieve the site associated with that group, if applicable.

\code{get_drive} retrieves a OneDrive or shared document library, and \code{list_drives} retrieves all such drives/libraries that the user or group has access to. Whether these are personal or business drives depends on the tenant that was specified in \code{AzureGraph::get_graph_login()}/\code{create_graph_login()}: if this was "consumers" or "9188040d-6c67-4c5b-b112-36a304b66dad" (the equivalent GUID), it will be the personal OneDrive. See the examples below.

Note that OneDrive for Business and SharePoint require a Microsoft 365 Business license, and are available for organisational tenants only.
}

\section{Value}{

For \code{get_sharepoint_site}, an object of class \code{ms_site}. For \code{get_drive}, an object of class \code{ms_drive}. For \code{list_drives}, a list of \code{ms_drive} objects.
}

\examples{
\dontrun{

# 'consumers' tenant -> personal OneDrive for a user
gr <- AzureGraph::get_graph_login("consumers", app="myapp")
me <- gr$get_user()
me$get_drive()

# organisational tenant -> business OneDrive for a user
gr2 <- AzureGraph::get_graph_login("mycompany", app="myapp")
myuser <- gr2$get_user("username@mycompany.onmicrosoft.com")
myuser$get_drive()

# get a site/drive directly from a URL/ID
gr2$get_sharepoint_site("https://mycompany.sharepoint.com/sites/my-site-name")
gr2$get_drive("drive-id")

# site/drive(s) for a group
grp <- gr2$get_group("group-id")
grp$get_sharepoint_site()
grp$list_drives()
grp$get_drive()

}
}
\seealso{
\link{ms_site}, \link{ms_drive}, \link{az_user}, \link{az_group}
}
