% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets_misc.R
\name{rename_samples}
\alias{rename_samples}
\title{Rename the samples of a phyloseq slot}
\usage{
rename_samples(phyloseq_component, names_of_samples, taxa_are_rows = FALSE)
}
\arguments{
\item{phyloseq_component}{(required) one of otu_table or sam_data slot of a
phyloseq-class object}

\item{names_of_samples}{(required) A vector of samples names}

\item{taxa_are_rows}{(default to FALSE) see ?phyloseq for details}
}
\value{
The otu_table or the sam_data slot with new samples names
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Useful for targets bioinformatic pipeline.
}
\examples{
otutab <- rename_samples(
  data_fungi@otu_table,
  paste0("data_f", sample_names(data_fungi))
)
otutab2 <- rename_samples(
  clean_pq(data_fungi,
    force_taxa_as_rows = TRUE
  )@otu_table,
  paste0("data_f", sample_names(data_fungi))
)
samda <- rename_samples(
  data_fungi@sam_data,
  paste0("data_f", sample_names(data_fungi))
)
}
\author{
Adrien Taudière
}
