% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterInit.R
\name{clusterInit}
\alias{clusterInit}
\title{Create an instance of [\code{\linkS4class{ClusterInit}}] class}
\usage{
clusterInit(method = "class", nbInit = 5, algo = "EM",
  nbIteration = 20, epsilon = 0.01)
}
\arguments{
\item{method}{Character string with the initialisation method.
Possible values: "random", "class", "fuzzy". Default value is "class".}

\item{nbInit}{integer defining the number of initialization point to test. Default value is 5.}

\item{algo}{String with the initialisation algorithm.
Possible values: "EM", "CEM", "SEM", "SemiSEM". Default value is "EM".}

\item{nbIteration}{Integer defining the number of iteration in \code{algo}.
nbIteration must be a positive integer. Default values is 20. if .}

\item{epsilon}{threshold to use in order to stop the iterations. Default value is 0.01.}
}
\value{
a [\code{\linkS4class{ClusterInit}}] object
}
\description{
The initialization step is a two stages process: the proper initialization step
and some (optionnals) iterations of an algorithm [\code{\link{clusterAlgo}}].
}
\details{
There is three ways to initialize the parameters:
\itemize{
  \item \code{random} {The initial parameters of the mixture are chosen randomly.}
  \item \code{class}  {The initial membership of individuals are sampled randomly.}
  \item \code{fuzzy}  {The initial probabilities of membership of individuals are
                       sampled randomly.}
}
A few iterations of an algorithm [\code{\link{clusterAlgo}}] are then performed.
It is strongly recommended to use a few number of iterations of the \code{EM}
or \code{SEM} algorithms after initialization. This allows to detect "bad"
initialization starting point.

These two stages are repeated until \code{nbInit} is reached. The initial
point with the best log-likelihood is conserved as the initial starting point.
}
\examples{
 clusterInit(method = "class", nbInit=1, algo="CEM",nbIteration=50, epsilon=0.00001)
 clusterInit(nbIteration=0) # no algorithm

}
\author{
Serge Iovleff
}
