% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matnormlda.R
\name{predict.matrixlda}
\alias{predict.matrixlda}
\title{Classify Matrix Variate Observations by Linear Discrimination}
\usage{
\method{predict}{matrixlda}(object, newdata, prior = object$prior, ...)
}
\arguments{
\item{object}{object of class \code{matrixlda}}

\item{newdata}{array or list of new observations to be classified.
If newdata is missing, an attempt will be made to retrieve the
data used to fit the \code{matrixlda} object.}

\item{prior}{The prior probabilities of the classes, by default the
proportions in the training set or what was set in the call to
\code{matrixlda}.}

\item{...}{arguments based from or to other methods}
}
\value{
Returns a list containing
   the following components:
   \describe{
      \item{\code{class}}{The MAP classification (a factor)}
      \item{\code{posterior}}{posterior probabilities for the classes}
   }
}
\description{
Classify matrix variate observations in conjunction with \code{matrixlda}.
}
\details{
This function is a method for the generic function \code{predict()} for
class "\code{matrixlda}". It can be invoked by calling \code{predict(x)} for
an object \code{x} of the appropriate class.
}
\examples{
set.seed(20180221)
# construct two populations of 3x4 random matrices with different means
A <- rmatrixnorm(30,mean=matrix(0,nrow=3,ncol=4))
B <- rmatrixnorm(30,mean=matrix(1,nrow=3,ncol=4))
C <- array(c(A,B), dim=c(3,4,60)) #combine together
groups <- c(rep(1,30),rep(2,30)) # define groups
prior <- c(.5,.5) # set prior
D <- matrixlda(C, groups, prior)
predict(D)$posterior[1:10,]

}
\seealso{
\code{\link{matrixlda}}, \code{\link{matrixqda}}, and \code{\link{matrixmixture}}
}
