% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_sources.R
\name{combine_sources}
\alias{combine_sources}
\title{Combine sources from a finished MixSIAR model (\emph{a posteriori})}
\usage{
combine_sources(jags.1, mix, source, alpha.prior = 1, groups)
}
\arguments{
\item{jags.1}{\code{rjags} model object, output from \code{\link{run_model}}}

\item{mix}{list, output from \code{\link{load_mix_data}}}

\item{source}{list, output from \code{\link{load_source_data}}}

\item{alpha.prior}{vector with length = n.sources, Dirichlet prior on p.global (default = 1, uninformative)}

\item{groups}{list, which sources to combine, and what names to give the new combined sources. See example.}
}
\value{
\code{combined}, a list including:
\itemize{
 \item \code{combined$post}: matrix, posterior draws with new source groupings
 \item \code{combined$source.new}: list, original \code{source} list with modified entries for \code{n.sources} and \code{source_names}
 \item \code{combined$groups}: (input) list, shows original and combined sources
 \item \code{combined$jags.1}: (input) \code{rjags} model object
 \item \code{combined$source.old}: (input) list of original source data
 \item \code{combined$mix}: (input) list of original mix data
 \item \code{combined$prior.old}: (input) prior vector on original sources
 \item \code{combined$prior.new}: (output) prior vector on combined sources
}
}
\description{
\code{combine_sources} aggregates the proportions from multiple sources.
Proportions are summed across posterior draws, since the source proportions
are correlated.
}
\details{
\emph{Note: Aggregating sources after running the mixing model (a posteriori)
effectively changes the prior weighting on the sources.} Aggregating
uneven numbers of sources will turn an 'uninformative'/generalist
prior into an informative one. Because of this, \code{combine_sources}
automatically generates a message describing this effect and a figure
showing the original prior, the effective/aggregated prior, and what the
'uninformative'/generalist prior would be if sources were instead grouped
before running the mixing model (a priori).
}
\examples{
\dontrun{
# first run mantis shrimp example
# combine 6 sources into 2 groups of interest (hard-shelled vs. soft-bodied)
#   'hard' = 'clam' + 'crab' + 'snail'           # group 1 = hard-shelled prey
#   'soft' = 'alphworm' + 'brittlestar' + 'fish' # group 2 = soft-bodied prey
combined <- combine_sources(jags.1, mix, source, alpha.prior=alpha, 
                groups=list(hard=c("clam","crab","snail"), soft=c("alphworm","brittlestar","fish")))

# get posterior medians for new source groupings
apply(combined$post, 2, median)
summary_stat(combined, meanSD=FALSE, quantiles=c(.025,.5,.975), savetxt=FALSE)
}
}
\seealso{
\code{\link{summary_stat}} and \code{\link{plot_intervals}}
}
